<?php
require_once __DIR__ . '/lib.php';

$slug = $_GET['slug'] ?? '';
$posts = read_posts();
$post = null;
foreach ($posts as $p) {
  if (($p['slug'] ?? '') === $slug) { $post = $p; break; }
}
if (!$post) { http_response_code(404); $title='Not Found'; include __DIR__ . '/partials/header.php'; ?>
  <div class="card rounded-3xl p-6">
    <div class="text-xl font-bold">404 — Post tidak ditemukan</div>
    <p class="muted mt-2">Kembali ke <a class="gold underline" href="<?=h(base_url())?>">daftar</a>.</p>
  </div>
<?php include __DIR__ . '/partials/footer.php'; exit; }

$title = $post['title'] ?? SITE_NAME;
include __DIR__ . '/partials/header.php';
?>

<article class="card rounded-3xl overflow-hidden gold-glow">
  <?php if (!empty($post['image'])): ?>
    <img src="<?=h(base_url('uploads/'.$post['image']))?>" class="w-full max-h-[520px] object-cover" alt="<?=h($title)?>">
  <?php endif; ?>
  <div class="p-6 md:p-10">
    <div class="text-xs muted"><?=h(format_date_id($post['date'] ?? date('Y-m-d')))?></div>
    <h1 class="text-2xl md:text-4xl font-extrabold mt-2"><?=h($title)?></h1>

    <?php if (!empty($post['excerpt'])): ?>
      <p class="muted mt-3"><?=h($post['excerpt'])?></p>
    <?php endif; ?>

    <div class="line my-6"></div>

    <div class="prose prose-invert max-w-none">
      <?php
        // render simple paragraphs (safe)
        $content = trim((string)($post['content'] ?? ''));
        if ($content === '') $content = '-';
        foreach (preg_split('/\r?\n\r?\n/', $content) as $para) {
          echo '<p class="muted leading-relaxed">' . nl2br(h(trim($para))) . '</p>';
        }
      ?>
    </div>

    <div class="mt-8 flex flex-wrap gap-3">
      <a class="px-5 py-2.5 rounded-2xl border gold-border muted hover:text-white transition" href="<?=h(base_url())?>">← Kembali</a>
      <?php if (is_admin()): ?>
        <a class="btn-gold px-5 py-2.5 rounded-2xl transition" href="<?=h(base_url('admin/edit.php?slug='.$slug))?>">Edit</a>
      <?php endif; ?>
    </div>
  </div>
</article>

<?php include __DIR__ . '/partials/footer.php'; ?>
