<?php
require_once __DIR__ . '/config.php';

function base_url($path='') {
  $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
  $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
  return $scheme . '://' . $host . rtrim(BASE_PATH, '/') . '/' . ltrim($path, '/');
}

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

function ensure_data_file() {
  $dir = dirname(DATA_FILE);
  if (!is_dir($dir)) mkdir($dir, 0755, true);
  if (!file_exists(DATA_FILE)) file_put_contents(DATA_FILE, json_encode([], JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));
}

function read_posts() {
  ensure_data_file();
  $raw = file_get_contents(DATA_FILE);
  $data = json_decode($raw, true);
  return is_array($data) ? $data : [];
}

function save_posts($posts) {
  ensure_data_file();
  file_put_contents(DATA_FILE, json_encode(array_values($posts), JSON_PRETTY_PRINT|JSON_UNESCAPED_UNICODE));
}

function slugify($text) {
  $text = strtolower(trim($text));
  $text = preg_replace('/[^a-z0-9\s-]/', '', $text);
  $text = preg_replace('/[\s-]+/', '-', $text);
  return trim($text, '-');
}

function is_admin() {
  return !empty($_SESSION['admin']) && $_SESSION['admin'] === true;
}

function require_admin() {
  if (!is_admin()) {
    header('Location: ' . base_url('admin/'));
    exit;
  }
}

function csrf_token() {
  if (empty($_SESSION['csrf'])) $_SESSION['csrf'] = bin2hex(random_bytes(16));
  return $_SESSION['csrf'];
}

function csrf_check() {
  $t = $_POST['csrf'] ?? '';
  return hash_equals($_SESSION['csrf'] ?? '', $t);
}

function format_date_id($ymd) {
  // input: YYYY-MM-DD
  $ts = strtotime($ymd);
  if (!$ts) $ts = time();
  $months = ['Januari','Februari','Maret','April','Mei','Juni','Juli','Agustus','September','Oktober','November','Desember'];
  $d = (int)date('j', $ts);
  $m = $months[(int)date('n',$ts)-1];
  $y = date('Y',$ts);
  return $d . ' ' . $m . ' ' . $y;
}

function upload_image($file, $allowed_mimes) {
  if (empty($file) || ($file['error'] ?? UPLOAD_ERR_NO_FILE) !== UPLOAD_ERR_OK) return [false, 'Upload gagal.'];
  $max = UPLOAD_MAX_MB * 1024 * 1024;
  if (($file['size'] ?? 0) > $max) return [false, 'Ukuran file melebihi batas ' . UPLOAD_MAX_MB . 'MB.'];

  $finfo = finfo_open(FILEINFO_MIME_TYPE);
  $mime = finfo_file($finfo, $file['tmp_name']);
  finfo_close($finfo);

  if (!isset($allowed_mimes[$mime])) return [false, 'Tipe file tidak didukung (hanya JPG/PNG/WebP).'];

  if (!is_dir(UPLOAD_DIR)) mkdir(UPLOAD_DIR, 0755, true);
  $ext = $allowed_mimes[$mime];
  $name = bin2hex(random_bytes(10)) . '.' . $ext;
  $dest = rtrim(UPLOAD_DIR, '/') . '/' . $name;

  if (!move_uploaded_file($file['tmp_name'], $dest)) return [false, 'Gagal menyimpan file.'];
  return [true, $name];
}
