<?php
require_once __DIR__ . '/lib.php';

$posts = read_posts();
// sort newest first by date then created_at
usort($posts, function($a,$b){
  $da = $a['date'] ?? '1970-01-01';
  $db = $b['date'] ?? '1970-01-01';
  if ($da === $db) return ($b['created_at'] ?? 0) <=> ($a['created_at'] ?? 0);
  return strcmp($db, $da);
});

$per_page = 9;
$page = max(1, (int)($_GET['page'] ?? 1));
$total = count($posts);
$total_pages = max(1, (int)ceil($total / $per_page));
$page = min($page, $total_pages);
$start = ($page - 1) * $per_page;
$items = array_slice($posts, $start, $per_page);

$title = 'Bukti Pembayaran';
include __DIR__ . '/partials/header.php';
?>

<section class="mb-8">
  <div class="card gold-glow rounded-3xl p-6 md:p-10">
    <div class="text-sm gold font-semibold tracking-widest uppercase">Bukti Pembayaran</div>
    <h1 class="text-2xl md:text-4xl font-extrabold mt-2 leading-tight">
      Galeri update harian <span class="gold">hitam pekat & gold</span>
    </h1>
    <p class="muted mt-3 max-w-2xl">
      Upload post harian via admin. Setiap post berisi gambar + judul + tanggal + deskripsi singkat.
    </p>
    <div class="mt-6 flex flex-wrap gap-3">
      <a class="btn-gold px-5 py-2.5 rounded-2xl transition" href="<?=h(base_url())?>">Lihat daftar</a>
      <?php if (is_admin()): ?>
        <a class="px-5 py-2.5 rounded-2xl border gold-border muted hover:text-white transition" href="<?=h(base_url('admin/new.php'))?>">Tambah post</a>
      <?php else: ?>
        <a class="px-5 py-2.5 rounded-2xl border gold-border muted hover:text-white transition" href="<?=h(base_url('admin/'))?>">Login admin</a>
      <?php endif; ?>
    </div>
  </div>
</section>

<section class="grid sm:grid-cols-2 lg:grid-cols-3 gap-5">
  <?php if (empty($items)): ?>
    <div class="card rounded-3xl p-6 muted">Belum ada post. Login admin untuk upload.</div>
  <?php endif; ?>

  <?php foreach($items as $p): 
    $slug = $p['slug'] ?? '';
    $img  = $p['image'] ?? '';
    $url  = base_url('p/' . $slug);
  ?>
  <article class="card rounded-3xl overflow-hidden gold-glow">
    <a href="<?=h($url)?>" class="block">
      <?php if ($img): ?>
        <img src="<?=h(base_url('uploads/'.$img))?>" class="w-full h-52 object-cover" loading="lazy" alt="<?=h($p['title'] ?? '')?>">
      <?php else: ?>
        <div class="w-full h-52 bg-white/5 flex items-center justify-center muted">No Image</div>
      <?php endif; ?>
    </a>
    <div class="p-5">
      <div class="text-xs muted"><?=h(format_date_id($p['date'] ?? date('Y-m-d')))?></div>
      <a href="<?=h($url)?>" class="block mt-1 font-bold text-lg hover:underline">
        <?=h($p['title'] ?? 'Tanpa Judul')?>
      </a>
      <p class="muted text-sm mt-2 line-clamp-3">
        <?=h($p['excerpt'] ?? '')?>
      </p>
      <div class="mt-4">
        <a href="<?=h($url)?>" class="inline-flex items-center gap-2 text-sm gold hover:underline">
          Baca selengkapnya <span aria-hidden="true">→</span>
        </a>
      </div>
    </div>
  </article>
  <?php endforeach; ?>
</section>

<?php if ($total_pages > 1): ?>
  <div class="mt-10 flex items-center justify-center gap-2 flex-wrap">
    <?php for($i=1;$i<=$total_pages;$i++): ?>
      <?php if ($i === $page): ?>
        <span class="px-3 py-2 rounded-xl border gold-border btn-gold"><?= $i ?></span>
      <?php else: ?>
        <a class="px-3 py-2 rounded-xl border gold-border muted hover:text-white" href="<?=h(base_url('?page='.$i))?>"><?= $i ?></a>
      <?php endif; ?>
    <?php endfor; ?>
  </div>
<?php endif; ?>

<?php include __DIR__ . '/partials/footer.php'; ?>
