<?php
require_once __DIR__ . '/../lib.php';
require_admin();

$posts = read_posts();
usort($posts, function($a,$b){
  $da = $a['date'] ?? '1970-01-01';
  $db = $b['date'] ?? '1970-01-01';
  if ($da === $db) return ($b['created_at'] ?? 0) <=> ($a['created_at'] ?? 0);
  return strcmp($db, $da);
});

$msg = $err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  if (!csrf_check()) { $err = 'Sesi tidak valid. Refresh halaman.'; }
  else {
    $slug = $_POST['slug'] ?? '';
    $all = read_posts();
    $new = [];
    foreach ($all as $p) {
      if (($p['slug'] ?? '') === $slug) {
        // delete image if exists
        if (!empty($p['image'])) {
          $fp = __DIR__ . '/../uploads/' . $p['image'];
          if (is_file($fp)) @unlink($fp);
        }
        continue;
      }
      $new[] = $p;
    }
    save_posts($new);
    $msg = '✅ Post dihapus.';
    // refresh list
    $posts = read_posts();
  }
}

$title = 'Kelola Post';
include __DIR__ . '/../partials/header.php';
?>
<div class="card rounded-3xl p-6 md:p-8 gold-glow">
  <h1 class="text-2xl font-extrabold">Kelola Post</h1>
  <p class="muted mt-2 text-sm">Hapus post yang tidak diperlukan.</p>

  <?php if ($msg): ?>
    <div class="mt-4 p-3 rounded-2xl border border-emerald-500/30 bg-emerald-500/10 text-sm"><?=h($msg)?></div>
  <?php endif; ?>
  <?php if ($err): ?>
    <div class="mt-4 p-3 rounded-2xl border border-red-500/30 bg-red-500/10 text-sm"><?=h($err)?></div>
  <?php endif; ?>

  <div class="mt-6 overflow-x-auto">
    <table class="w-full text-sm">
      <thead class="text-left muted">
        <tr>
          <th class="py-2 pr-3">Tanggal</th>
          <th class="py-2 pr-3">Judul</th>
          <th class="py-2 pr-3">Link</th>
          <th class="py-2 pr-3">Aksi</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach($posts as $p): $slug=$p['slug']??''; ?>
          <tr class="border-t border-white/5">
            <td class="py-3 pr-3 muted whitespace-nowrap"><?=h(format_date_id($p['date'] ?? date('Y-m-d')))?></td>
            <td class="py-3 pr-3"><?=h($p['title'] ?? '')?></td>
            <td class="py-3 pr-3">
              <a class="gold underline" href="<?=h(base_url('p/'.$slug))?>" target="_blank">/p/<?=h($slug)?></a>
            </td>
            <td class="py-3 pr-3">
              <form method="post" onsubmit="return confirm('Hapus post ini?');">
                <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
                <input type="hidden" name="slug" value="<?=h($slug)?>">
                <button class="px-3 py-2 rounded-xl border border-red-500/30 bg-red-500/10 hover:bg-red-500/20 text-red-200">Hapus</button>
              </form>
            </td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>

  <div class="mt-6">
    <a class="px-5 py-2.5 rounded-2xl border gold-border muted hover:text-white transition" href="<?=h(base_url('admin/new.php'))?>">← Kembali</a>
  </div>
</div>
<?php include __DIR__ . '/../partials/footer.php'; ?>
