<?php
require_once __DIR__ . '/../lib.php';

if (is_admin()) { header('Location: ' . base_url('admin/new.php')); exit; }

$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $u = trim($_POST['username'] ?? '');
  $p = $_POST['password'] ?? '';
  if (!csrf_check()) {
    $err = 'Sesi tidak valid. Refresh halaman.';
  } elseif ($u === ADMIN_USERNAME && password_verify($p, ADMIN_PASSWORD_HASH)) {
    $_SESSION['admin'] = true;
    header('Location: ' . base_url('admin/new.php'));
    exit;
  } else {
    $err = 'Username / password salah.';
  }
}

$title = 'Login Admin';
include __DIR__ . '/../partials/header.php';
?>
<div class="max-w-lg mx-auto">
  <div class="card rounded-3xl p-6 md:p-8 gold-glow">
    <h1 class="text-2xl font-extrabold">Admin Login</h1>
    <p class="muted mt-2 text-sm">Masuk untuk upload post harian.</p>

    <?php if ($err): ?>
      <div class="mt-4 p-3 rounded-2xl border border-red-500/30 bg-red-500/10 text-sm"><?=h($err)?></div>
    <?php endif; ?>

    <form class="mt-5 space-y-4" method="post">
      <input type="hidden" name="csrf" value="<?=h(csrf_token())?>">
      <div>
        <label class="text-sm muted">Username</label>
        <input name="username" value="admin" class="mt-1 w-full px-4 py-3 rounded-2xl bg-black/40 border gold-border focus:outline-none focus:ring-2 focus:ring-yellow-500/30" required>
      </div>
      <div>
        <label class="text-sm muted">Password</label>
        <input type="password" name="password" class="mt-1 w-full px-4 py-3 rounded-2xl bg-black/40 border gold-border focus:outline-none focus:ring-2 focus:ring-yellow-500/30" required>
      </div>
      <button class="btn-gold w-full px-5 py-3 rounded-2xl transition" type="submit">Masuk</button>
    </form>

    <div class="mt-5 text-xs muted">
      Tips: ganti password default via <span class="gold">genhash.php</span> di root folder.
    </div>
  </div>
</div>
<?php include __DIR__ . '/../partials/footer.php'; ?>
